import { useState, useEffect } from 'react';

interface UseMobileOptions {
  breakpoint?: number; // px width below which is considered mobile
}

export function useMobile({ breakpoint = 768 }: UseMobileOptions = {}) {
  const [isMobile, setIsMobile] = useState(() => {
    if (typeof window === 'undefined') return false;
    return window.innerWidth < breakpoint;
  });

  useEffect(() => {
    const handleResize = () => {
      setIsMobile(window.innerWidth < breakpoint);
    };

    window.addEventListener('resize', handleResize);
    
    // Initial check
    handleResize();
    
    return () => window.removeEventListener('resize', handleResize);
  }, [breakpoint]);

  return isMobile;
}

export function useIsMobile() {
  return useMobile({ breakpoint: 768 });
}