# V2G Platform

## Overview

The V2G (Vehicle-to-Grid) Platform is a professional fleet management and grid integration system designed for real-time monitoring, dispatch management, and economic optimization of electric vehicles. The platform enables utilities and fleet operators to coordinate EV battery resources with grid demand, providing services like peak shaving, demand response, and ancillary grid services. Built with a modern full-stack architecture, it features an interactive map interface, real-time vehicle monitoring, grid requirement management, and comprehensive analytics dashboards.

## User Preferences

Preferred communication style: Simple, everyday language.

## System Architecture

### Frontend Architecture
The client is built using React with TypeScript and follows a component-based architecture. The UI leverages shadcn/ui components with Radix UI primitives for accessibility and customization. The design system implements a professional dark-mode theme optimized for grid management interfaces, drawing inspiration from Tesla's energy dashboard and enterprise grid platforms.

Key architectural decisions:
- **Component Library**: shadcn/ui with Radix UI for consistent, accessible components
- **Styling**: Tailwind CSS with custom design tokens for grid management aesthetics
- **State Management**: React hooks and context for local state, TanStack Query for server state
- **Routing**: Wouter for lightweight client-side routing
- **Maps**: React Leaflet for interactive vehicle positioning and grid visualization

### Backend Architecture
The server uses Express.js with TypeScript in an ESM module setup. The architecture follows a simple REST API pattern with modular route registration and middleware-based request handling.

Key architectural decisions:
- **Runtime**: Node.js with native ESM modules
- **Framework**: Express.js for HTTP server and middleware
- **Development**: Vite for hot module replacement and development tooling
- **Build**: esbuild for production bundling with external package handling

### Data Storage Solutions
The application uses Drizzle ORM with PostgreSQL for structured data persistence. The schema defines core entities for vehicle management, grid operations, and user authentication.

Database design decisions:
- **ORM**: Drizzle for type-safe database operations and schema management
- **Database**: PostgreSQL (configured via Neon serverless connector)
- **Schema**: Structured tables for vehicles, users, V2G calls, and grid invitations
- **Migrations**: Drizzle Kit for database schema evolution

### Authentication and Authorization
Currently implements a basic user model with session-based authentication patterns. The system includes user creation and lookup functionality through the storage interface.

Authentication approach:
- **Session Management**: Express session middleware with PostgreSQL session store
- **User Model**: Simple username/password authentication
- **Storage Interface**: Abstracted storage layer for user management operations

## External Dependencies

### UI and Component Libraries
- **Radix UI**: Comprehensive primitive components for accessibility and customization
- **Tailwind CSS**: Utility-first CSS framework for rapid UI development
- **Lucide React**: Icon library for consistent iconography
- **Framer Motion**: Animation library for smooth UI transitions

### Data Visualization
- **Recharts**: React-based charting library for demand curves and analytics
- **React Leaflet**: Interactive mapping components for vehicle positioning

### Database and Backend Services
- **Neon Database**: Serverless PostgreSQL provider for cloud database hosting
- **Drizzle ORM**: Type-safe ORM for database operations and schema management
- **Express.js**: Web application framework for API development

### Development and Build Tools
- **Vite**: Frontend build tool and development server
- **TypeScript**: Type safety across frontend and backend
- **esbuild**: Fast JavaScript bundler for production builds
- **TanStack Query**: Server state management and caching

### Form and Validation
- **React Hook Form**: Performant form library with minimal re-renders
- **Zod**: TypeScript-first schema validation library
- **Hookform Resolvers**: Integration between React Hook Form and Zod validation

The platform is designed for scalability with cloud-native deployment patterns, supporting both development and production environments through environment-specific configurations.