import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Checkbox } from "@/components/ui/checkbox";
import { StatusBadge, type ChargerStatus } from "./StatusBadge";
import { Play, Square, MoreHorizontal } from "lucide-react";

interface FleetCharger {
  id: string;
  name: string;
  location: string;
  status: ChargerStatus;
  power?: string;
  vehicle?: string;
}

const mockFleetChargers: FleetCharger[] = [
  { id: "1", name: "Station A-1", location: "North Depot", status: "charging", power: "7.4", vehicle: "Fleet-101" },
  { id: "2", name: "Station A-2", location: "North Depot", status: "idle" },
  { id: "3", name: "Station B-1", location: "South Depot", status: "charging", power: "11.0", vehicle: "Fleet-205" },
  { id: "4", name: "Station B-2", location: "South Depot", status: "idle" },
  { id: "5", name: "Station C-1", location: "East Depot", status: "offline" },
];

export function FleetDashboard() {
  return (
    <Card data-testid="card-fleet-dashboard">
      <CardHeader>
        <div className="flex items-center justify-between">
          <CardTitle>Fleet Chargers</CardTitle>
          <div className="flex gap-2">
            <Button size="sm" variant="outline" data-testid="button-bulk-start">
              <Play className="h-4 w-4 mr-2" />
              Start Selected
            </Button>
            <Button size="sm" variant="outline" data-testid="button-bulk-stop">
              <Square className="h-4 w-4 mr-2" />
              Stop Selected
            </Button>
          </div>
        </div>
      </CardHeader>
      <CardContent>
        <div className="space-y-2">
          {mockFleetChargers.map((charger) => (
            <div
              key={charger.id}
              className="flex items-center gap-4 p-3 rounded-lg bg-card border border-card-border hover-elevate"
              data-testid={`fleet-charger-${charger.id}`}
            >
              <Checkbox data-testid={`checkbox-${charger.id}`} />
              <div className="flex-1 grid grid-cols-4 gap-4 items-center">
                <div>
                  <div className="font-medium">{charger.name}</div>
                  <div className="text-sm text-muted-foreground">{charger.location}</div>
                </div>
                <div>
                  <StatusBadge status={charger.status} />
                </div>
                <div>
                  {charger.power && (
                    <div className="font-semibold text-primary">
                      {charger.power} kW
                    </div>
                  )}
                  {charger.vehicle && (
                    <div className="text-sm text-muted-foreground">{charger.vehicle}</div>
                  )}
                </div>
                <div className="flex justify-end">
                  <Button variant="ghost" size="icon" className="h-8 w-8">
                    <MoreHorizontal className="h-4 w-4" />
                  </Button>
                </div>
              </div>
            </div>
          ))}
        </div>
      </CardContent>
    </Card>
  );
}
