import { useState } from "react";
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Input } from "@/components/ui/input";
import { Label } from "@/components/ui/label";
import { Progress } from "@/components/ui/progress";
import { AlertCircle } from "lucide-react";

export function LoadManagementPanel() {
  const [breakerLimit, setBreakerLimit] = useState("100");
  const [currentLoad, setCurrentLoad] = useState(67);
  const [chargerLoad, setChargerLoad] = useState(32);

  const percentage = (currentLoad / parseInt(breakerLimit || "100")) * 100;
  const isNearLimit = percentage > 80;

  return (
    <Card data-testid="panel-load-management">
      <CardHeader>
        <CardTitle>Load Management</CardTitle>
      </CardHeader>
      <CardContent className="space-y-6">
        <div className="space-y-2">
          <Label htmlFor="breaker-limit">Main Breaker Limit (A)</Label>
          <Input
            id="breaker-limit"
            type="number"
            value={breakerLimit}
            onChange={(e) => setBreakerLimit(e.target.value)}
            data-testid="input-breaker-limit"
          />
        </div>

        <div className="space-y-3">
          <div className="flex items-center justify-between">
            <span className="text-sm font-medium">Current Building Load</span>
            <span className="text-2xl font-bold">
              {currentLoad}
              <span className="text-sm text-muted-foreground ml-1">A</span>
            </span>
          </div>
          <Progress
            value={percentage}
            className={isNearLimit ? "bg-destructive/20" : ""}
          />
          <div className="flex items-center justify-between text-sm text-muted-foreground">
            <span>Charger: {chargerLoad}A</span>
            <span>{percentage.toFixed(0)}% of limit</span>
          </div>
          {isNearLimit && (
            <div className="flex items-center gap-2 text-sm text-warning">
              <AlertCircle className="h-4 w-4" />
              <span>Approaching capacity limit</span>
            </div>
          )}
        </div>

        <div className="pt-4 border-t space-y-2">
          <h4 className="font-semibold text-sm">Dynamic Modulation</h4>
          <p className="text-sm text-muted-foreground">
            Charger current will automatically adjust to stay below building limits.
          </p>
          <Button variant="outline" className="w-full" data-testid="button-configure-rules">
            Configure Rules
          </Button>
        </div>
      </CardContent>
    </Card>
  );
}
