import { Card, CardContent } from "@/components/ui/card";
import { Badge } from "@/components/ui/badge";
import { Calendar, Clock, Zap, MapPin } from "lucide-react";

interface SessionHistoryItemProps {
  sessionId: string;
  chargerName: string;
  location: string;
  startTime: string;
  endTime: string;
  duration: string;
  energyDispensed: number;
  mode: "standard" | "eco" | "boost";
  outcome: "success" | "error";
  onClick?: () => void;
}

export function SessionHistoryItem({
  sessionId,
  chargerName,
  location,
  startTime,
  endTime,
  duration,
  energyDispensed,
  mode,
  outcome,
  onClick,
}: SessionHistoryItemProps) {
  const modeColors = {
    standard: "bg-primary/20 text-primary",
    eco: "bg-warning/20 text-warning",
    boost: "bg-destructive/20 text-destructive",
  };

  return (
    <Card
      className="hover-elevate cursor-pointer"
      onClick={onClick}
      data-testid={`session-${sessionId}`}
    >
      <CardContent className="p-4">
        <div className="flex items-start justify-between gap-4">
          <div className="flex-1 space-y-2">
            <div className="flex items-center gap-2">
              <h4 className="font-semibold">{chargerName}</h4>
              <Badge variant="outline" className={modeColors[mode]}>
                {mode}
              </Badge>
              {outcome === "error" && (
                <Badge variant="outline" className="bg-destructive/20 text-destructive">
                  Error
                </Badge>
              )}
            </div>
            <div className="flex items-center gap-1 text-sm text-muted-foreground">
              <MapPin className="h-3 w-3" />
              <span>{location}</span>
            </div>
            <div className="flex items-center gap-4 text-sm text-muted-foreground">
              <div className="flex items-center gap-1">
                <Calendar className="h-3 w-3" />
                <span>{startTime}</span>
              </div>
              <div className="flex items-center gap-1">
                <Clock className="h-3 w-3" />
                <span>{duration}</span>
              </div>
            </div>
          </div>
          <div className="text-right">
            <div className="text-2xl font-bold text-primary">
              {energyDispensed.toFixed(1)}
            </div>
            <div className="text-xs text-muted-foreground">kWh</div>
          </div>
        </div>
      </CardContent>
    </Card>
  );
}
