import { Badge } from "@/components/ui/badge";
import { cn } from "@/lib/utils";

export type ChargerStatus = "charging" | "idle" | "error" | "paused" | "offline";

interface StatusBadgeProps {
  status: ChargerStatus;
  className?: string;
}

const statusConfig = {
  charging: {
    label: "Charging",
    className: "bg-primary/20 text-primary border-primary/30",
    pulse: true,
  },
  idle: {
    label: "Idle",
    className: "bg-idle/20 text-idle border-idle/30",
    pulse: false,
  },
  error: {
    label: "Error",
    className: "bg-destructive/20 text-destructive border-destructive/30",
    pulse: false,
  },
  paused: {
    label: "Paused",
    className: "bg-warning/20 text-warning border-warning/30",
    pulse: false,
  },
  offline: {
    label: "Offline",
    className: "bg-muted/20 text-muted-foreground border-muted/30",
    pulse: false,
  },
};

export function StatusBadge({ status, className }: StatusBadgeProps) {
  const config = statusConfig[status];

  return (
    <Badge
      variant="outline"
      className={cn(
        "text-xs font-medium uppercase tracking-wide",
        config.className,
        config.pulse && "animate-pulse",
        className
      )}
      data-testid={`badge-status-${status}`}
    >
      {config.label}
    </Badge>
  );
}
