import { ChargerCard } from "../ChargerCard";

export default function ChargerCardExample() {
  return (
    <div className="p-8 grid grid-cols-1 md:grid-cols-3 gap-4 max-w-6xl">
      <ChargerCard
        id="1"
        name="Home Driveway"
        location="Main Residence"
        status="charging"
        power="7.4"
        lastActivity="Active now"
        onStart={() => console.log("Start")}
        onSettings={() => console.log("Settings")}
        onClick={() => console.log("View details")}
      />
      <ChargerCard
        id="2"
        name="Office Parking"
        location="Downtown Office"
        status="idle"
        lastActivity="2 hours ago"
        onStart={() => console.log("Start")}
        onSettings={() => console.log("Settings")}
      />
      <ChargerCard
        id="3"
        name="Guest Charger"
        location="Main Residence"
        status="offline"
        lastActivity="Yesterday"
        onStart={() => console.log("Start")}
        onSettings={() => console.log("Settings")}
      />
    </div>
  );
}
