import { useState } from "react";
import { ChargingModeSelector, type ChargingMode } from "../ChargingModeSelector";

export default function ChargingModeSelectorExample() {
  const [mode, setMode] = useState<ChargingMode>("standard");

  return (
    <div className="p-8 max-w-2xl">
      <ChargingModeSelector value={mode} onChange={setMode} />
      <p className="mt-4 text-sm text-muted-foreground">
        Selected: {mode}
      </p>
    </div>
  );
}
