import { SessionHistoryItem } from "../SessionHistoryItem";

export default function SessionHistoryItemExample() {
  return (
    <div className="p-8 max-w-2xl space-y-3">
      <SessionHistoryItem
        sessionId="session-1"
        chargerName="Home Driveway"
        location="Main Residence"
        startTime="Today 14:30"
        endTime="16:45"
        duration="2h 15m"
        energyDispensed={15.3}
        mode="standard"
        outcome="success"
        onClick={() => console.log("View session details")}
      />
      <SessionHistoryItem
        sessionId="session-2"
        chargerName="Office Parking"
        location="Downtown Office"
        startTime="Yesterday 09:00"
        endTime="17:30"
        duration="8h 30m"
        energyDispensed={42.7}
        mode="eco"
        outcome="success"
        onClick={() => console.log("View session details")}
      />
      <SessionHistoryItem
        sessionId="session-3"
        chargerName="Home Driveway"
        location="Main Residence"
        startTime="Dec 28 20:00"
        endTime="Interrupted"
        duration="0h 45m"
        energyDispensed={3.2}
        mode="boost"
        outcome="error"
        onClick={() => console.log("View session details")}
      />
    </div>
  );
}
