import { UserAccessPanel } from "@/components/UserAccessPanel";
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Calendar } from "lucide-react";

const reservations = [
  { id: "1", user: "John Doe", charger: "Home Driveway", time: "Today 18:00 - 22:00" },
  { id: "2", user: "Jane Smith", charger: "Guest Charger", time: "Tomorrow 14:00 - 16:00" },
  { id: "3", user: "Mike Johnson", charger: "Office Parking", time: "Dec 31 09:00 - 17:00" },
];

export default function Access() {
  return (
    <div className="space-y-6">
      <div>
        <h1 className="text-4xl font-bold">User Access</h1>
        <p className="text-muted-foreground mt-2">
          Manage shared access and reservations
        </p>
      </div>

      <div className="grid grid-cols-1 xl:grid-cols-2 gap-6">
        <UserAccessPanel />
        
        <Card data-testid="card-reservations">
          <CardHeader>
            <div className="flex items-center justify-between">
              <CardTitle>Upcoming Reservations</CardTitle>
              <Button size="sm" variant="outline" data-testid="button-add-reservation">
                <Calendar className="h-4 w-4 mr-2" />
                New
              </Button>
            </div>
          </CardHeader>
          <CardContent className="space-y-3">
            {reservations.map((reservation) => (
              <div
                key={reservation.id}
                className="flex items-center justify-between p-3 rounded-lg bg-card border border-card-border"
                data-testid={`reservation-${reservation.id}`}
              >
                <div>
                  <div className="font-medium">{reservation.user}</div>
                  <div className="text-sm text-muted-foreground">{reservation.charger}</div>
                </div>
                <div className="text-sm text-muted-foreground text-right">
                  {reservation.time}
                </div>
              </div>
            ))}
          </CardContent>
        </Card>
      </div>

      <Card>
        <CardHeader>
          <CardTitle>Usage Breakdown</CardTitle>
        </CardHeader>
        <CardContent>
          <div className="space-y-4">
            <div className="flex items-center justify-between">
              <div className="flex items-center gap-3">
                <div className="w-12 h-12 rounded-lg bg-primary/20 flex items-center justify-center font-bold text-primary">
                  JD
                </div>
                <div>
                  <div className="font-medium">John Doe</div>
                  <div className="text-sm text-muted-foreground">42 sessions</div>
                </div>
              </div>
              <div className="text-right">
                <div className="text-2xl font-bold">287.4</div>
                <div className="text-xs text-muted-foreground">kWh</div>
              </div>
            </div>
            <div className="flex items-center justify-between">
              <div className="flex items-center gap-3">
                <div className="w-12 h-12 rounded-lg bg-info/20 flex items-center justify-center font-bold text-info">
                  JS
                </div>
                <div>
                  <div className="font-medium">Jane Smith</div>
                  <div className="text-sm text-muted-foreground">38 sessions</div>
                </div>
              </div>
              <div className="text-right">
                <div className="text-2xl font-bold">245.6</div>
                <div className="text-xs text-muted-foreground">kWh</div>
              </div>
            </div>
            <div className="flex items-center justify-between">
              <div className="flex items-center gap-3">
                <div className="w-12 h-12 rounded-lg bg-warning/20 flex items-center justify-center font-bold text-warning">
                  MJ
                </div>
                <div>
                  <div className="font-medium">Mike Johnson</div>
                  <div className="text-sm text-muted-foreground">28 sessions</div>
                </div>
              </div>
              <div className="text-right">
                <div className="text-2xl font-bold">178.3</div>
                <div className="text-xs text-muted-foreground">kWh</div>
              </div>
            </div>
          </div>
        </CardContent>
      </Card>
    </div>
  );
}
