# FlowBankOS Design Guidelines

## Design Approach
**Design System Foundation**: Modern Utility Application inspired by Linear, Vercel Dashboard, and Stripe Dashboard
- **Rationale**: FlowBankOS is a utility-focused, data-intensive platform requiring clarity, efficiency, and real-time information display
- **Key Principles**: Information hierarchy, functional clarity, real-time feedback visibility, responsive precision

## Core Design Elements

### A. Color Palette

**Dark Mode (Primary)**
- Background: 220 15% 8% (deep slate)
- Surface: 220 15% 12% (card backgrounds)
- Surface Elevated: 220 15% 16% (modals, popovers)
- Border: 220 15% 20% (subtle dividers)
- Border Accent: 220 20% 30% (focused states)

**Brand & Semantic Colors**
- Primary: 142 76% 36% (electric green - charging, success states)
- Primary Muted: 142 50% 25% (hover states)
- Accent: 217 91% 60% (blue - information, links)
- Warning: 38 92% 50% (amber - caution states)
- Error: 0 84% 60% (red - errors, critical alerts)
- Charging Active: 142 100% 45% (bright green glow)
- Idle State: 220 10% 40% (neutral gray)

**Text Colors**
- Primary Text: 220 10% 95%
- Secondary Text: 220 8% 65%
- Tertiary Text: 220 8% 50%
- Disabled: 220 8% 35%

**Light Mode**
- Background: 0 0% 100%
- Surface: 220 15% 98%
- Text Primary: 220 15% 15%
- Borders: 220 15% 88%

### B. Typography

**Font Families**
- Primary: 'Inter' (UI, data, controls)
- Monospace: 'JetBrains Mono' (session IDs, technical data, codes)

**Scale & Usage**
- Display (text-4xl, font-bold): Dashboard headers, section titles
- Heading 1 (text-2xl, font-semibold): Page titles, modal headers
- Heading 2 (text-xl, font-semibold): Card headers, subsection titles
- Heading 3 (text-lg, font-medium): Component headers
- Body (text-base, font-normal): Primary content, descriptions
- Body Small (text-sm, font-normal): Supporting text, metadata
- Caption (text-xs, font-medium): Labels, tags, timestamps
- Monospace Data (text-sm, font-mono): Session IDs, serial numbers, technical specs

### C. Layout System

**Spacing Primitives**: Use Tailwind units of 2, 4, 6, 8, 12, 16, 20, 24
- Micro spacing (p-2, gap-2): Tight groupings, icon padding
- Component spacing (p-4, gap-4): Card internal padding, form fields
- Section spacing (p-6, gap-6, p-8, gap-8): Between major sections
- Page margins (p-12, p-16): Desktop container padding
- Large gaps (gap-20, gap-24): Between page sections

**Grid System**
- Dashboard: 12-column grid with responsive breakpoints
- Charger Cards: grid-cols-1 md:grid-cols-2 xl:grid-cols-3
- Fleet Table: Full-width with horizontal scroll on mobile
- Analytics: 2-column layout (chart + metrics) on desktop, stack on mobile

**Container Widths**
- Main Content: max-w-7xl mx-auto
- Forms/Settings: max-w-2xl
- Modals: max-w-lg to max-w-4xl (depending on content)

### D. Component Library

**Navigation**
- Top Bar: Logo, location switcher, notifications bell, user avatar
- Sidebar (Desktop): Collapsible navigation with icons + labels, active state with accent border
- Mobile: Bottom tab bar with 4-5 primary actions
- Breadcrumbs: For deep navigation (Location → Charger → Session)

**Dashboards & Cards**
- Live Status Cards: Prominent power gauge (circular or arc), kW display (text-3xl, font-bold), supporting metrics grid (2×2 or 3×1)
- Charger Cards: Status badge (top-right), charger name/ID, last activity timestamp, quick actions (Start/Stop icon buttons)
- Metrics Display: Label (text-xs, uppercase, tracking-wide, text-secondary), Value (text-2xl, font-semibold), Unit (text-sm, text-secondary)

**Data Visualization**
- Live Power Gauge: Circular progress (0-100% of max capacity), center shows current kW in large font, outer ring color indicates mode (green=standard, amber=eco, red=boost)
- Charts: Use Chart.js or Recharts with dark mode color scheme, bar charts for monthly kWh, line charts for trends, grid with subtle borders
- Tables: Alternating row backgrounds (surface/background), sticky headers, hover states (surface-elevated), sort indicators

**Forms & Inputs**
- Text Inputs: Dark background (220 15% 10%), border (220 15% 25%), focus border (primary color), rounded-lg, p-3
- Select/Dropdown: Same styling as text inputs, chevron icon, custom dropdown with search for long lists
- Segmented Controls: For charging modes (Standard/Eco/Boost), pill-shaped segments, active state with primary background
- Sliders: For current limits, thick track (h-2), prominent thumb, show value above thumb
- Toggle Switches: iOS-style, green when active

**Buttons & Actions**
- Primary: bg-primary, text-white, rounded-lg, px-6 py-3, font-medium
- Secondary: bg-surface-elevated, border border-border-accent, text-primary
- Destructive: bg-error, text-white (for Stop, Delete actions)
- Icon Buttons: Square (w-10 h-10), rounded-lg, hover bg-surface-elevated
- FAB (Mobile): Fixed bottom-right, primary color, shadow-lg, for quick Start action

**Status Indicators**
- Badges: Rounded-full px-3 py-1, text-xs font-medium, uppercase tracking-wide
  - Charging: bg-primary/20, text-primary, with pulse animation
  - Idle: bg-idle/20, text-idle
  - Error: bg-error/20, text-error
  - Paused: bg-warning/20, text-warning
- Connection Status: Small colored dot (w-2 h-2) next to charger name

**Modals & Overlays**
- Background Overlay: bg-black/60 backdrop-blur-sm
- Modal Container: bg-surface-elevated, rounded-xl, shadow-2xl, border border-border-accent
- Headers: Border-bottom, close button (top-right)
- Footer Actions: Border-top, right-aligned buttons

**Maps**
- Use Mapbox or Leaflet with dark mode tiles
- Custom markers: Circular with status color border, charger icon in center
- Cluster markers for multiple chargers at same location
- Info popups: Match card styling

**Notifications & Alerts**
- Toast Notifications: Fixed top-right, slide-in animation, auto-dismiss
- Banner Alerts: Full-width, sticky top, icon + message + close button
- Push Notification Style: System-native with app icon, action buttons

**Loading States**
- Skeleton Loaders: Pulse animation, match component shapes
- Spinners: Primary color, 24px for inline, 48px for page-level
- Progress Bars: Thin (h-1), primary color, for firmware updates

**QR Scanner**
- Full-screen overlay with camera feed
- Centered scanning frame (rounded-lg, border-accent, dashed)
- Torch toggle (bottom-left), manual entry button (bottom-right)
- Success animation: Green checkmark with scale effect

### E. Responsive Behavior

**Breakpoints**
- Mobile: <768px (single column, bottom nav, simplified metrics)
- Tablet: 768-1024px (2-column grids, sidebar collapses to icons)
- Desktop: >1024px (full sidebar, multi-column dashboards, expanded data views)

**Mobile Optimizations**
- Touch Targets: Minimum 44×44px for all interactive elements
- Swipe Gestures: Swipe to reveal actions on list items
- Pull-to-Refresh: On dashboard and history views
- Native-like Navigation: Bottom tabs, slide transitions between views

### F. Special Features

**Real-Time Updates**
- Live data refreshes with subtle pulse effect on changed values
- WebSocket connection indicator in top bar
- Optimistic UI updates for user actions

**Installer Mode**
- Distinct visual treatment: Orange accent color instead of green
- Lock icon always visible in header
- Step-by-step wizard with progress bar
- Diagnostic displays with technical details (voltage, current, temperature)

**Fleet View**
- Dense table layout with inline editing capabilities
- Batch selection with checkbox column
- Floating action bar for bulk operations
- Gantt chart for scheduling with drag-drop

### G. Animations
Use sparingly and purposefully:
- Page Transitions: Fade (200ms)
- Modal Enter/Exit: Scale + fade (250ms, ease-out)
- Charging Pulse: Subtle glow animation on active status badge (2s loop)
- Metric Updates: Number counter animation for kWh changes
- Button Interactions: Default browser/framework hover states only
- No scroll-triggered animations, no parallax effects

### Images
No hero images required. This is a utility application focused on data and controls. Use:
- Charger icons/photos in device cards (small, 80×80px thumbnails)
- Empty states: Simple illustrations (line art style) for "No chargers yet", "No sessions", etc.
- User avatars: Circular, 32×32px in nav, 48×48px in settings
- QR code placeholders during scanning flow