export interface SingaporeLocation {
  id: string;
  name: string;
  address: string;
  area: string;
  lat: number;
  lng: number;
  pricePerKwh: number;
  peakPricePerKwh: number;
}

export interface ChargerLocation extends SingaporeLocation {
  chargerId: string;
  chargerName: string;
  status: "charging" | "idle" | "offline";
  power?: string;
  maxPower: number;
  v2gCapable?: boolean;
  connectorType?: string;
}

export const singaporeLocations: SingaporeLocation[] = [
  {
    id: "loc-1",
    name: "Orchard Central",
    address: "181 Orchard Rd, Singapore 238896",
    area: "Orchard",
    lat: 1.3012,
    lng: 103.8395,
    pricePerKwh: 0.45,
    peakPricePerKwh: 0.65,
  },
  {
    id: "loc-2",
    name: "Marina Bay Sands",
    address: "10 Bayfront Ave, Singapore 018956",
    area: "Marina Bay",
    lat: 1.2834,
    lng: 103.8607,
    pricePerKwh: 0.55,
    peakPricePerKwh: 0.75,
  },
  {
    id: "loc-3",
    name: "Changi Business Park",
    address: "5 Changi Business Park Central 1, Singapore 486038",
    area: "Changi",
    lat: 1.3343,
    lng: 103.9632,
    pricePerKwh: 0.40,
    peakPricePerKwh: 0.60,
  },
  {
    id: "loc-4",
    name: "Toa Payoh Hub",
    address: "530 Lor 6 Toa Payoh, Singapore 310530",
    area: "Toa Payoh",
    lat: 1.3324,
    lng: 103.8479,
    pricePerKwh: 0.38,
    peakPricePerKwh: 0.58,
  },
  {
    id: "loc-5",
    name: "Jurong Point",
    address: "1 Jurong West Central 2, Singapore 648886",
    area: "Jurong West",
    lat: 1.3397,
    lng: 103.7066,
    pricePerKwh: 0.35,
    peakPricePerKwh: 0.52,
  },
  {
    id: "loc-6",
    name: "Punggol Digital District",
    address: "Punggol Coast Rd, Singapore 820001",
    area: "Punggol",
    lat: 1.4044,
    lng: 103.9037,
    pricePerKwh: 0.42,
    peakPricePerKwh: 0.62,
  },
  {
    id: "loc-7",
    name: "Sentosa Gateway",
    address: "Sentosa Gateway, Singapore 098269",
    area: "Sentosa",
    lat: 1.2587,
    lng: 103.8230,
    pricePerKwh: 0.50,
    peakPricePerKwh: 0.70,
  },
  {
    id: "loc-8",
    name: "Seletar Aerospace Park",
    address: "70 Seletar Aerospace View, Singapore 797564",
    area: "Seletar",
    lat: 1.4166,
    lng: 103.8693,
    pricePerKwh: 0.40,
    peakPricePerKwh: 0.58,
  },
];

export const singaporeChargers: ChargerLocation[] = [
  {
    id: "loc-1",
    chargerId: "1",
    chargerName: "Orchard Central A1",
    name: "Orchard Central",
    address: "181 Orchard Rd, Singapore 238896",
    area: "Orchard",
    lat: 1.3012,
    lng: 103.8395,
    status: "charging",
    power: "7.4",
    maxPower: 11,
    pricePerKwh: 0.45,
    peakPricePerKwh: 0.65,
    v2gCapable: true,
    connectorType: "Type 2",
  },
  {
    id: "loc-1",
    chargerId: "2",
    chargerName: "Orchard Central A2",
    name: "Orchard Central",
    address: "181 Orchard Rd, Singapore 238896",
    area: "Orchard",
    lat: 1.3014,
    lng: 103.8397,
    status: "idle",
    maxPower: 11,
    pricePerKwh: 0.45,
    peakPricePerKwh: 0.65,
    v2gCapable: false,
    connectorType: "Type 2",
  },
  {
    id: "loc-2",
    chargerId: "3",
    chargerName: "Marina Bay Sands B1",
    name: "Marina Bay Sands",
    address: "10 Bayfront Ave, Singapore 018956",
    area: "Marina Bay",
    lat: 1.2834,
    lng: 103.8607,
    status: "charging",
    power: "10.8",
    maxPower: 22,
    pricePerKwh: 0.55,
    peakPricePerKwh: 0.75,
    v2gCapable: true,
    connectorType: "CCS2",
  },
  {
    id: "loc-3",
    chargerId: "4",
    chargerName: "Changi Business Park C1",
    name: "Changi Business Park",
    address: "5 Changi Business Park Central 1, Singapore 486038",
    area: "Changi",
    lat: 1.3343,
    lng: 103.9632,
    status: "idle",
    maxPower: 22,
    pricePerKwh: 0.40,
    peakPricePerKwh: 0.60,
    v2gCapable: true,
    connectorType: "CCS2",
  },
  {
    id: "loc-4",
    chargerId: "5",
    chargerName: "Toa Payoh Hub D1",
    name: "Toa Payoh Hub",
    address: "530 Lor 6 Toa Payoh, Singapore 310530",
    area: "Toa Payoh",
    lat: 1.3324,
    lng: 103.8479,
    status: "offline",
    maxPower: 7,
    pricePerKwh: 0.38,
    peakPricePerKwh: 0.58,
    v2gCapable: false,
    connectorType: "Type 2",
  },
  {
    id: "loc-5",
    chargerId: "6",
    chargerName: "Jurong Point E1",
    name: "Jurong Point",
    address: "1 Jurong West Central 2, Singapore 648886",
    area: "Jurong West",
    lat: 1.3397,
    lng: 103.7066,
    status: "idle",
    maxPower: 11,
    pricePerKwh: 0.35,
    peakPricePerKwh: 0.52,
    v2gCapable: false,
    connectorType: "Type 2",
  },
  {
    id: "loc-6",
    chargerId: "7",
    chargerName: "Punggol Digital District F1",
    name: "Punggol Digital District",
    address: "Punggol Coast Rd, Singapore 820001",
    area: "Punggol",
    lat: 1.4044,
    lng: 103.9037,
    status: "idle",
    maxPower: 22,
    pricePerKwh: 0.42,
    peakPricePerKwh: 0.62,
    v2gCapable: true,
    connectorType: "CCS2",
  },
  {
    id: "loc-6",
    chargerId: "8",
    chargerName: "Punggol Digital District F2",
    name: "Punggol Digital District",
    address: "Punggol Coast Rd, Singapore 820001",
    area: "Punggol",
    lat: 1.4046,
    lng: 103.9039,
    status: "charging",
    power: "22.0",
    maxPower: 22,
    pricePerKwh: 0.42,
    peakPricePerKwh: 0.62,
    v2gCapable: true,
    connectorType: "CCS2",
  },
  {
    id: "loc-7",
    chargerId: "9",
    chargerName: "Sentosa Gateway G1",
    name: "Sentosa Gateway",
    address: "Sentosa Gateway, Singapore 098269",
    area: "Sentosa",
    lat: 1.2587,
    lng: 103.8230,
    status: "idle",
    maxPower: 11,
    pricePerKwh: 0.50,
    peakPricePerKwh: 0.70,
    v2gCapable: false,
    connectorType: "Type 2",
  },
  {
    id: "loc-8",
    chargerId: "10",
    chargerName: "Seletar Aerospace Park H1",
    name: "Seletar Aerospace Park",
    address: "70 Seletar Aerospace View, Singapore 797564",
    area: "Seletar",
    lat: 1.4166,
    lng: 103.8693,
    status: "idle",
    maxPower: 22,
    pricePerKwh: 0.40,
    peakPricePerKwh: 0.58,
    v2gCapable: true,
    connectorType: "CCS2",
  },
];
